//Created by Peoharen for the Mobile Abilities Package.
using System;
using Server.Mobiles;
using Xanthos.Evo;

namespace Server.Mobiles
{
	//[CorpseName( "a corpse" )]
	public class BaseSummonedEvoSpider : BaseSummoned
	{
		public override bool AlwaysAttackable{ get{ return false; } }
		
      private EvoSpider m_Master;

		public EvoSpider Master
		{
			get{ return m_Master; }
			set{ m_Master = value; }
		}

		public BaseSummonedEvoSpider( EvoSpider master ) : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			m_Master = master;
			m_DecayTime = DateTime.Now + TimeSpan.FromMinutes( 2.0 );
			
			if ( m_Master != null )
			{
            m_Master.Guardians.Add( this );
            Hue = m_Master.Hue;
            Name = m_Master.Name;
         }
         else
         {
            Name = "a mirror spider minion";
            Hue = 768;
         }
		}

		public override void OnGaveMeleeAttack( Mobile defender )
		{
			if ( m_Master == null || defender == null || defender.Deleted || defender is TrainingElemental  || !defender.CanBeDamaged() )
				return;

         if ( defender is BaseCreature )
			{
				BaseCreature bc = (BaseCreature)defender;

				if ( m_Master.Alive && !bc.Controlled )
				{
               BaseEvoSpec spec = BaseEvoEgg.GetEvoSpec( m_Master );
               
               if ( null != spec && null != spec.Stages )
               {
                  m_Master.Ep += Utility.RandomMinMax( 5 + ( bc.HitsMax ) / spec.Stages[m_Master.Stage].EpMinDivisor, 5 + ( bc.HitsMax ) / spec.Stages[m_Master.Stage].EpMaxDivisor );
               }
            }
			}

			base.OnGaveMeleeAttack( defender );
		}
		
		public override void OnThink()
		{
			base.OnThink();
         
         if ( m_Master != null )
         {
            if ( this.Map != m_Master.Map )
               this.Delete();
            else if ( m_Master.ControlOrder == OrderType.Attack && ( m_Master.ControlTarget != null && m_Master.ControlTarget is BaseCreature ) )
    			{
    			   if ( this.Combatant == null )
    			   {
                  this.Combatant = m_Master.ControlTarget;
                  this.ControlOrder = OrderType.Attack;
                  this.ControlTarget = m_Master.ControlTarget;
               }
            }
            else
    			{
    			   if ( this.Combatant == null && this.ControlOrder != OrderType.Follow )
    			   {
                  this.Combatant = null;
                  this.ControlOrder = OrderType.Follow;
                  this.ControlTarget = m_Master;
               }
            }
         }
		}

		public override bool OnBeforeDeath()
		{
			if ( m_Master != null && !m_Master.DeletingSummons )
            m_Master.Guardians.Remove( this );
            
			return base.OnBeforeDeath();
		}
		
		public override void OnAfterDelete()
		{
			if ( m_Master != null && !m_Master.DeletingSummons )
            m_Master.Guardians.Remove( this );

			base.OnAfterDelete();
		}
		
    	public override bool OnMoveOver( Mobile m )
    	{
    		return true;
    	}

		public BaseSummonedEvoSpider(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			m_DecayTime = DateTime.Now + TimeSpan.FromMinutes( 1.0 );
		}
	}
}